/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.shadowmobs.model;

import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.model.ModelCustomObj;
import com.lycanitesmobs.shadowmobs.ShadowMobs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelChupacabra
extends ModelCustomObj {
    float maxLeg = 0.0f;

    public ModelChupacabra() {
        this(1.0f);
    }

    public ModelChupacabra(float shadowSize) {
        this.initModel("chupacabra", ShadowMobs.group, "entity/chupacabra");
        this.setPartCenter("head", 0.0f, 0.81f, 0.39f);
        this.setPartCenter("mouth", 0.0f, 0.65f, 0.8f);
        this.setPartCenter("body", 0.0f, 0.7f, 0.0f);
        this.setPartCenter("armleft", 0.39f, 0.7f, 0.12f);
        this.setPartCenter("armright", -0.39f, 0.7f, 0.12f);
        this.setPartCenter("legleft", 0.25f, 0.55f, -0.5f);
        this.setPartCenter("legright", -0.25f, 0.55f, -0.5f);
        this.setPartCenter("tailleft", 0.1f, 0.5f, -0.74f);
        this.setPartCenter("tailright", -0.1f, 0.5f, -0.74f);
        this.trophyScale = 0.8f;
        this.trophyOffset = new float[]{0.0f, -0.2f, 0.0f};
    }

    @Override
    public void animatePart(String partName, EntityLiving entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        super.animatePart(partName, entity, time, distance, loop, lookY, lookX, scale);
        float pi = (float)Math.PI;
        float posX = 0.0f;
        float posY = 0.0f;
        float posZ = 0.0f;
        float angleX = 0.0f;
        float angleY = 0.0f;
        float angleZ = 0.0f;
        float rotation = 0.0f;
        float rotX = 0.0f;
        float rotY = 0.0f;
        float rotZ = 0.0f;
        if (partName.equals("mouth")) {
            this.centerPartToPart("mouth", "head");
            if (!this.lockHeadX) {
                this.rotate((float)Math.toDegrees(lookX / 57.295776f), 0.0f, 0.0f);
            }
            if (!this.lockHeadY) {
                this.rotate(0.0f, (float)Math.toDegrees(lookY / 57.295776f), 0.0f);
            }
            this.uncenterPartToPart("mouth", "head");
        }
        if (partName.equals("mouth")) {
            this.rotate((float)(-Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.1f)) * 0.1f - 0.1f)), 0.0f, 0.0f);
        }
        if (partName.equals("tailleft")) {
            rotX = (float)(-Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.1f)) * 0.05f - 0.05f));
            rotY = (float)(-Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.05f - 0.05f));
        }
        if (partName.equals("tailright")) {
            rotX = (float)Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.1f)) * 0.05f - 0.05f);
            rotY = (float)Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.05f - 0.05f);
        }
        float walkSwing = 0.6f;
        if (partName.equals("armright") || partName.equals("legleft")) {
            rotX = (float)((double)rotX + Math.toDegrees(MathHelper.func_76134_b((float)(time * 0.6662f + (float)Math.PI)) * walkSwing * distance));
        }
        if (partName.equals("armleft") || partName.equals("legright")) {
            rotX = (float)((double)rotX + Math.toDegrees(MathHelper.func_76134_b((float)(time * 0.6662f)) * walkSwing * distance));
        }
        if (entity instanceof EntityCreatureBase && ((EntityCreatureBase)entity).justAttacked()) {
            if (partName.equals("armleft")) {
                this.rotate(-75.0f, 0.0f, 0.0f);
            }
            if (partName.equals("armright")) {
                this.rotate(-75.0f, 0.0f, 0.0f);
            }
        }
        this.rotate(rotation, angleX, angleY, angleZ);
        this.rotate(rotX, rotY, rotZ);
        this.translate(posX, posY, posZ);
    }

    @Override
    public void childScale(String partName) {
        if (partName.equals("head")) {
            this.translate(-(this.getPartCenter(partName)[0] / 2.0f), -(this.getPartCenter(partName)[1] / 2.0f), -(this.getPartCenter(partName)[2] / 2.0f));
        } else {
            super.childScale(partName);
        }
    }
}

